<?php
/**
 * Server-side rendering of the `core/post-title` block.
 *
 * @package WordPress
 */

/**
 * Renders the `core/post-title` block on the server.
 *
 * @param array    $attributes Block attributes.
 * @param string   $content    Block default content.
 * @param WP_Block $block      Block instance.
 *
 * @return string Returns the filtered post title for the current post wrapped inside "h1" tags.
 */
function gutenberg_render_block_core_post_title( $attributes, $content, $block ) {
	if ( ! isset( $block->context['postId'] ) ) {
		return '';
	}

	$tag_name         = 'h2';
	$align_class_name = empty( $attributes['textAlign'] ) ? '' : ' ' . "has-text-align-{$attributes['textAlign']}";

	if ( isset( $attributes['level'] ) ) {
		$tag_name = 0 === $attributes['level'] ? 'p' : 'h' . $attributes['level'];
	}

	return sprintf(
		'<%1$s class="%2$s">%3$s</%1$s>',
		$tag_name,
		'wp-block-post-title' . esc_attr( $align_class_name ),
		get_the_title( $block->context['postId'] )
	);
}

/**
 * Registers the `core/post-title` block on the server.
 */
function gutenberg_register_block_core_post_title() {
	register_block_type_from_metadata(
		__DIR__ . '/post-title',
		array(
			'render_callback' => 'gutenberg_render_block_core_post_title',
		)
	);
}
add_action( 'init', 'gutenberg_register_block_core_post_title', 20 );
